------------------------------------------------------------------------
-- Event:        Delphi Day 2018, Piacenza, June 06 2018               -
--               https://www.delphiday.it/                             -
-- Seminary:     How to write high performance queries in T-SQL        -
-- Demo:         Execution Plan - The first operator                   -
-- Author:       Sergio Govoni                                         -
-- Notes:        --                                                    -
------------------------------------------------------------------------

USE [AdventureWorks2017];
GO

DBCC FREEPROCCACHE;
GO

------------------------------------------------------------------------
-- The first operator                                                  -
------------------------------------------------------------------------

-- Optimization level
-- MemoryGrantInfo
-- EstimatedAvailableDegreeOfParallelism
-- Set Options

SELECT
  *
FROM
  Sales.SalesOrderHeader AS h
JOIN
  Sales.SalesOrderDetail AS d
  ON h.SalesOrderID=d.SalesOrderID;
GO


-- Reason for Early Termination

SELECT
  *
FROM
  Sales.SalesOrderHeader AS h
JOIN
  Sales.SalesOrderDetail AS d
  ON h.SalesOrderID=d.SalesOrderID
WHERE
  (d.ProductID = 29);
GO



--Table 'OrderDetail'. Scan count 1, logical reads 948,

-- ANSI_NULLS option

SET STATISTICS IO ON

--SET ANSI_NULLS ON -- <-- Default
SET ANSI_NULLS OFF

DECLARE
  @CustomerID INTEGER = 1
  ,@OrderHeaderID INTEGER = 1200;

SELECT
  OH.OrderID
  ,MAX(OH.OrderDATE)
  ,OH.OrderNUMBER
  ,OH.CustomerID
  ,OH.ShipName
  ,OH.ShipAddress
  ,OH.ShipVia
  ,OH.ShipCity
  ,OH.ShipRegion
  ,OH.ShipPostalCode
  ,OH.ShipCountry
  ,SUM(OD.UnitPrice)
FROM
  dbo.OrderHeader OH
LEFT OUTER JOIN
  dbo.OrderDetail OD ON OD.OrderHeaderID = OH.OrderID
WHERE
  (OH.CustomerID = @CustomerID)
  AND (OD.OrderHeaderID = @OrderHeaderID)
GROUP BY
  OH.OrderID, OH.OrderNUMBER, OH.CustomerID, OH.ShipName
  ,OH.ShipAddress, OH.ShipVia, OH.ShipCity, OH.ShipRegion
  ,OH.ShipPostalCode, OH.ShipCountry;
GO


/*
EXEC sp_helpindex 'dbo.OrderDetail';
EXEC sp_helpindex 'dbo.OrderHeader';


DBCC DROPCLEANBUFFERS;
GO

DELETE FROM dbo.OrderDetail WHERE OrderHeaderID=1100;
SELECT * FROM dbo.OrderDetail WHERE OrderHeaderID=1100;
SELECT * FROM dbo.OrderHeader WHERE NOT EXISTS (SELECT OrderHeaderID FROM dbo.OrderDetail WHERE OrderDetail.OrderHeaderID = OrderHeader.OrderID)
*/
GO


/*
-- ANSI_NULLS ON  --> 0 row(s) affected!!
-- ANSI_NULLS OFF --> 1 row(s) affected!!
*/

SET STATISTICS IO ON

--SET ANSI_NULLS ON -- <-- Default
SET ANSI_NULLS OFF

DECLARE
  @CustomerId INTEGER = 1
  ,@OrderHeaderID INTEGER = NULL;

SELECT
  *
FROM
  dbo.OrderHeader OH
LEFT OUTER JOIN
  dbo.OrderDetail OD ON OD.OrderHeaderID = OH.OrderID
WHERE
  (OH.CustomerId = @CustomerId)
  AND (OD.OrderHeaderID = @OrderHeaderID);
  --AND (OD.OrderHeaderID IS NULL);
GO




-- PARAMETER LIST

EXEC dbo.usp_StateProvinceByTerritory N'USA';
GO

EXEC dbo.usp_StateProvinceByTerritory N'Australia';
GO